<?php

namespace FacturaPyme;

defined('FACTURAPYME_VER') || exit;

function nFormat($number)
{
    if (trim($number)) {
        return number_format($number, 0, ',', '.');
    }
    return $number == 0 ? 0 : '';
}
function rutFormat($rut)
{
    list($rut, $digito) = explode('-', trim($rut));
    return nFormat($rut) . '-' . strtoupper($digito);
}
function cleanRut($rut)
{
    return str_replace('.', '', trim(strtoupper((string)$rut)));
}
function digitoVerificadorRut($rut)
{
    $suma = 1;
    for ($modulo = 0; $rut != 0; $rut /= 10) {
        $suma = ($suma + $rut % 10 * (9 - $modulo++ % 6)) % 11;
    }
    return chr($suma ? $suma + 47 : 75);
}
function validaRut($rut)
{
    $rut = cleanRut((string) $rut);
    if (strlen($rut) < 3) {
        return false;
    }
    $tmp = explode('-', strtoupper($rut));
    if (count($tmp) !== 2 || strlen($tmp[1]) != 1
        || !ctype_digit($tmp[0]) || (!ctype_digit($tmp[1]) && $tmp[1] != 'K')
        || strlen($tmp[0]) > 8
    ) {
        return false;
    }
    $dvc = digitoVerificadorRut($tmp[0]);
    return $dvc === $tmp[1];
}

function ddd($data)
{
    echo '<pre>';
    var_dump($data);
    echo '</pre>';
    wp_die();
}
function array_get($array, $key, $default = null)
{
    if (isset($array[$key])) {
        return $array[$key];
    }
    return $default;
}
// source: Laravel Framework
// https://github.com/laravel/framework/blob/8.x/src/Illuminate/Support/Str.php

function str_starts_with($haystack, $needle)
{
    return strncmp($haystack, $needle, strlen($needle)) === 0;
}
function throw_if($condition, $exception)
{
    if ($condition) {
        throw $exception;
    }
    return $condition;
}
function abort_if($condition)
{
    if ($condition) {
        wp_die();
    }
}
function db()
{
    global $wpdb;
    return $wpdb;
}
function tableName($name)
{
    $wpdb = db();
    return $wpdb->prefix . $name;
}
function facturado($id)
{
    static $lastId = false;
    if ($lastId === $id) {
        return true;
    }
    $lastId = $id;
    return false;
}
function notificaError($message)
{
    static $notificado = false;
    if ($notificado) {
        return ;
    }
    $notificado = true;
    add_action('admin_notices', function () use ($message) {
        ?><div class="error notice"><p><?php echo $message; ?></p></div><?php
    });
}

function encrypt($text)
{
    $iv = mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB), MCRYPT_RAND);
    $hash = hash('sha256', wp_salt(), true);
    return base64_encode(mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $hash, $text, MCRYPT_MODE_ECB, $iv));
}

function decrypt($encrypted)
{
    $iv = mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB), MCRYPT_RAND);
    $hash = hash('sha256', wp_salt(), true);
    return trim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $hash, base64_decode($encrypted), MCRYPT_MODE_ECB, $iv));
}
