<?php

namespace FacturaPyme;

use Exception;

defined('FACTURAPYME_VER') || exit;

class FacturaPyme
{
    /**
     * Static property to hold our singleton instance
     *
     */
    public static $instance = false;

    /**
     * This is our constructor
     *
     * @return void
     */
    private function __construct()
    {
        add_action('admin_init', [$this, 'adminInit']);
        add_action('rest_api_init', [$this, 'setApiRoutes']);
        add_action('woocommerce_order_status_completed', [$this, 'statusCompletado'], 20);
        add_action('woocommerce_thankyou', [$this, 'checkFormaPago'], 20);
    }

    /**
     * If an instance exists, this returns it.  If not, it creates one and
     * retuns it.
     *
     * @return FacturaPyme
     */
    public static function getInstance()
    {
        if (!self::$instance) {
            self::$instance = new self;
        }
        return self::$instance;
    }

    public function adminInit()
    {
        $this->registerSettings();
        $this->validateInstall();
    }

    public function setApiRoutes()
    {
        $namespace = 'wc/v3/facturapyme';
        register_rest_route($namespace, '/init', [
            'methods' => 'POST',
            'callback' => [$this, 'init'],
            'permission_callback' => [$this, 'checkPermission'],
            'enabled' => true,
        ]);
        register_rest_route($namespace, '/tipo-dte', [
            'methods' => 'POST',
            'callback' => [$this, 'setTipoDtes'],
            'permission_callback' => [$this, 'checkPermission'],
            'enabled' => true,
        ]);
        register_rest_route($namespace, '/actualiza-pedido', [
            'methods' => 'POST',
            'callback' => [$this, 'actualizaPedido'],
            'permission_callback' => [$this, 'checkPermission'],
            'enabled' => true,
        ]);
        /*
        register_rest_route($namespace, '/status', [
            'methods' => 'GET',
            'callback' => [$this, 'status'],
            'permission_callback' => [$this, 'checkPermission'],
            'enabled' => true,
        ]);
        */
    }

    public function statusCompletado($id)
    {
        if (get_option('facturapyme_genera_on_completed', 'S') == 'N') {
            return;
        }
        throw_if(!$id, new Exception('Order_id No valido'));
        $pedido = Pedido::fromId($id);
        $pedido->facturar();
    }

    public function checkFormaPago($id)
    {
        throw_if(!$id, new Exception('Order_id No valido'));
        $pedido = Pedido::fromId($id);
        $pedido->facturarFromCheckout();
    }

    public function setTipoDtes($request)
    {
        $data = $request->get_json_params();
        if (!isset($data['tipo_dte'])) {
            return ['ok' => false, 'msg' => 'Debe Enviar los tipo_dte disponibles!', 'data' => $data];
        }
        delete_option('facturapyme_tipos_dte');
        add_option('facturapyme_tipos_dte', $data['tipo_dte']);
        delete_option('facturapyme_bodega');
        if (isset($data['bodega'])) {
            add_option('facturapyme_bodega', $data['bodega']);
        }
        return ['ok' => true, 'msg' => 'OK!'];
    }

    public function init($request)
    {
        $data = $request->get_json_params();
        $url = array_get($data, 'fp_url');
        $key = array_get($data, 'fp_key');
        if (!$url || !$key) {
            return ['ok' => false, 'msg' => 'No Key or Not Url!', 'data' => $data];
        }
        //delete_option('facturapyme_api_connection');
        add_option('facturapyme_api_connection', ['url' => $url, 'key' => $key]);
        return ['ok' => true, 'msg' => 'OK!'];
    }

    public function checkPermission()
    {
        return current_user_can('manage_options');
    }

    public function actualizaPedido($request)
    {
        $data = $request->get_json_params();
        $id = intval(array_get($data, 'id', 0));
        $tipo = sanitize_text_field(array_get($data, 'tipo'));
        $folio = intval(array_get($data, 'folio', 0));
        abort_if(!$id || !$tipo || !$folio);
        db()->update(
            tableName('order_dte'),
            ['estado' => 1, 'tipo_dte' => $tipo, 'folio' => $folio, 'pdf' => array_get($data, 'pdf')],
            ['order_id' => $id]
        );
        db()->query('DELETE FROM ' . tableName('order_dte_log') . "  WHERE order_id = '" . $id . "' AND estado <> 1");
        return ['ok' => true, 'msg' => 'OK!'];
    }

    protected function validateInstall()
    {
        if (!class_exists('woocommerce')) {
            notificaError('FacturaPyme: Necesita tener instalado WooCommerce Para Poder Generar Documentos tributarios.');
            return;
        }
        $facturapyme = get_option('facturapyme_api_connection');
        if (!$facturapyme) {
            notificaError('FacturaPyme: Debe conectar facturapyme con esta tienda');
            return;
        }
    }

    protected function registerSettings()
    {
        $settings = [
            'facturapyme_default_dte',
            'facturapyme_incluye_envio',
            'facturapyme_genera_on_completed',
            'facturapyme_formas_pago',
            'facturapyme_rut_dte',
            'facturapyme_razon_social_dte',
            'facturapyme_comuna_dte',
            'facturapyme_giro_dte',
        ];
        foreach ($settings as $setting) {
            register_setting('facturapyme-plugin-settings-group', $setting);
        }
    }
}

FacturaPyme::getInstance();
