<?php

namespace FacturaPyme;

use Exception;

defined('FACTURAPYME_VER') || exit;

class FacturaPymeAdmin
{
    /**
     * Static property to hold our singleton instance
     *
     */
    public static $instance = false;

    /**
     * This is our constructor
     *
     * @return void
     */
    private function __construct()
    {
        add_action('admin_menu', [$this, 'registerAdminPage']);
        $pluginName = plugin_basename(str_replace('-admin.php', '-plugin.php', __FILE__));
        add_filter('plugin_action_links_' . $pluginName, [$this, 'ajustesLink']);
        register_activation_hook($pluginName, [$this, 'setup']);
        add_action('woocommerce_admin_order_data_after_billing_address', [$this, 'datosFacturapyme']);
        add_action('wp_ajax_facturapyme_gen_dte', [$this, 'generaDte']);
        add_action('wp_ajax_facturapyme_save_dte', [$this, 'saveDte']);
    }

    /**
     * If an instance exists, this returns it.  If not, it creates one and
     * retuns it.
     *
     * @return FacturaPymeAdmin
     */
    public static function getInstance()
    {
        if (!self::$instance) {
            self::$instance = new self;
        }
        return self::$instance;
    }

    public function registerAdminPage()
    {
        add_submenu_page('woocommerce', 'Configuración FacturaPyme', 'FacturaPyme', 'manage_options', 'facturapyme_settings', [$this, 'configuraMenu']);
    }

    public function configuraMenu()
    {
        require dirname(__FILE__) . '/admin/configuracion.php';
    }

    public function setup()
    {
        require dirname(__FILE__) . '/admin/setup.php';
    }
    protected function pedidoFromRequest($request)
    {
        throw_if(!isset($request['order_id']), new Exception('Sin Order_id'));
        $id = intval($request['order_id']);
        throw_if(!$id, new Exception('Order_id No valido'));
        return Pedido::fromId($id);
    }
    public function generaDte()
    {
        $request = filter_input_array(INPUT_POST);
        $pedido = $this->pedidoFromRequest($request);
        $pedido->setMeta($request);
        $pedido->facturar();
        wp_die(); // this is required to terminate immediately and return a proper response
    }

    public function saveDte()
    {
        $request = filter_input_array(INPUT_POST);
        $pedido = $this->pedidoFromRequest($request);
        $pedido->setMeta($request);
        wp_die(); // this is required to terminate immediately and return a proper response
    }

    public function datosFacturapyme($order)
    {
        if (!$order) {
            return;
        }
        require dirname(__FILE__) . '/admin/datos-pedido.php';
    }

    public function ajustesLink($links)
    {
        $myLinks = [
            '<a href="' . admin_url('admin.php?page=facturapyme_settings') .
            '">' . __('Settings') . '</a>'
        ];
        return array_merge($myLinks, $links);
    }
}

FacturaPymeAdmin::getInstance();
