<?php

defined('FACTURAPYME_VER') || exit;
$tiposDte = get_option('facturapyme_tipos_dte', []);
if (!$tiposDte) {
    echo '<h1>Debe configurar los documentos que utilizara en Facturapy.me</h1>';
    return;
}
$conFactura = FacturaPyme\DataSource::conFactura();
$tipoDtesArray = FacturaPyme\DataSource::tipos();

$configuraciones = [
    'facturapyme_default_dte' => [
        'label' => 'Documento Por Defecto',
        'default' => 39,
        'options' => $tipoDtesArray
    ],
    'facturapyme_incluye_envio' => [
        'label' => 'Incluir valor del envio en el documento emitido',
        'default' => 'S',
        'options' => ['S' => 'Sí', 'N' => 'No']
    ],
    'facturapyme_genera_on_completed' => [
        'label' => 'Generar DTE cuando el estado del pedido está en COMPLETADO',
        'default' => 'N',
        'options' => ['S' => 'Sí', 'N' => 'No']
    ],
];
$formaPagos = WC()->payment_gateways->get_available_payment_gateways();
$configFormasPagos = get_option('facturapyme_formas_pago', []);
$billingFields = [];
if ($conFactura) {
    $billingFields = get_option('wc_fields_billing', []);
    $billingFields = is_array($billingFields) ? array_filter($billingFields) : [];
    if (empty($billingFields) || sizeof($billingFields) == 0) {
        $billingFields = WC()->countries->get_address_fields(WC()->countries->get_base_country(), 'billing' . '_');
    }
}
?><form method="post" action="options.php">
<?php
    settings_fields('facturapyme-plugin-settings-group');
    do_settings_sections('facturapyme-plugin-settings-group');
?>
<table class="form-table">
<?php foreach ($configuraciones as $id => $config): ?>
<tr valign="top">
    <th scope="row">
        <label for='<?php echo $id; ?>'><?php echo $config['label']; ?></label>
    </th>
    <td scope="row">
        <select name="<?php echo $id; ?>" id ="<?php echo $id; ?>">
        <?php
        $current = get_option($id, $config['default']);
        foreach ($config['options'] as $key => $value) {
            ?><option value="<?php echo $key; ?>" <?php echo $key == $current ? 'selected' : ''; ?>><?php echo $value; ?></option>
        <?php
        } ?>
        </select>
    </td>
</tr>
<?php endforeach;/*configuraciones*/?>
<?php if ($formaPagos): ?>
<tr valign="top">
    <th scope="row" colspan=2><h3>Emisión de documento según Forma de Pago</h3></th>
</tr>
<?php
$id = 'facturapyme_formas_pago';
foreach ($formaPagos as $key => $value):
?>
<tr valign="top">
    <th scope="row">
        <label for='<?php echo $id . '_' . $key; ?>'><?php echo $value->title; ?></label>
    </th>
    <td scope="row">
        <select name="<?php echo $id . '[' . $key . ']'; ?>" id ="<?php echo $id . '_' . $key; ?>">
        <?php
        $current = FacturaPyme\array_get($configFormasPagos, $key, 'M');
        $options = ['A' => 'Automatico', 'M' => 'Manual'];
        foreach ($options as $key => $value) {
            ?><option value="<?php echo $key; ?>" <?php echo $key == $current ? 'selected' : ''; ?>><?php echo $value; ?></option>
        <?php
        } ?>
        </select>
    </td>
</tr>
<?php endforeach; ?>
<?php endif; ?>

<?php if ($billingFields): ?>
<tr valign="top">
    <th scope="row" colspan=2><h3>Campos Facturación</h3></th>
</tr>
<?php
$configuraciones = [
    'facturapyme_rut_dte' => [
        'label' => 'RUT',
        'default' => 'facturapyme_rut_field',
    ],
    'facturapyme_razon_social_dte' => [
        'label' => 'Razón Social',
        'default' => 'billing_company',
    ],
    'facturapyme_giro_dte' => [
        'label' => 'Giro',
        'default' => 'facturapyme_giro_field',
    ],
    'facturapyme_comuna_dte' => [
        'label' => 'Comuna',
        'default' => 'facturapyme_comuna_field',
    ],
];
//echo '<pre>';var_dump($billingFields);echo '</pre>';
foreach ($billingFields as $key => $value) {
    if (!$value['label'] && isset($value['placeholder'])) {
        $billingFields[$key]['label'] = $value['placeholder'];
    }
    if (FacturaPyme\str_starts_with($key, 'facturapyme')) {
        unset($billingFields[$key]);
    }
}
?>
<?php foreach ($configuraciones as $id => $config): ?>
<tr valign="top">
    <th scope="row">
        <label for='<?php echo $id; ?>'><?php echo $config['label']; ?></label>
    </th>
    <td scope="row">
        <select name="<?php echo $id; ?>" id ="<?php echo $id; ?>" required>
        <option value="">---</option>
        <?php
        $current = get_option($id, $config['default']);
        if ($id === 'facturapyme_rut_dte') {
            $key = 'facturapyme_rut_field'; ?>
            <option value="<?php echo $key; ?>" <?php echo $key == $current ? 'selected' : ''; ?>>Facturapyme::Rut</option><?php
        }
        if ($id === 'facturapyme_comuna_dte') {
            $key = 'facturapyme_comuna_field'; ?>
            <option value="<?php echo $key; ?>" <?php echo $key == $current ? 'selected' : ''; ?>>Facturapyme::Comuna</option><?php
        }
        if ($id === 'facturapyme_giro_dte') {
            $key = 'facturapyme_giro_field'; ?>
            <option value="<?php echo $key; ?>" <?php echo $key == $current ? 'selected' : ''; ?>>Facturapyme::Giro</option><?php
        }
        foreach ($billingFields as $key => $value) {
            ?><option value="<?php echo $key; ?>" <?php echo $key == $current ? 'selected' : ''; ?>><?php echo $value['label']; ?> (<?php echo $key ?>)</option>
        <?php
        }
        ?>
        </select>
    </td>
</tr>
<?php endforeach;/*configuraciones*/?>

<?php endif; ?>
</table>
<?php submit_button(); ?>
</form>
