<?php

namespace FacturaPyme;

defined('FACTURAPYME_VER') || exit;

class DataSource
{
    protected static $conFactura;
    protected static $listadoDtes = [];
    protected static $bodega;
    public static function init()
    {
        $tiposDte = get_option('facturapyme_tipos_dte', []);
        self::$conFactura = false;
        self::$listadoDtes = [];
        foreach ($tiposDte as $tipo) {
            self::$listadoDtes[$tipo['id']] = $tipo['name'];
            self::$conFactura = self::$conFactura || $tipo['id'] == 33 || $tipo['id'] == 34;
        }
        self::$bodega = get_option('facturapyme_bodega', null);
    }

    public static function tipos()
    {
        return self::$listadoDtes;
    }

    public static function conFactura()
    {
        return self::$conFactura;
    }

    public static function bodega()
    {
        return self::$bodega;
    }
}
DataSource::init();
