<?php

namespace FacturaPyme;

defined('FACTURAPYME_VER') || exit;

class BillingField
{
    protected $fields = [];
    protected $priority = 1;

    public function __construct($fields)
    {
        $this->fields = $fields;
    }

    public function get()
    {
        $tipoDtesArray = DataSource::tipos();
        if (!$tipoDtesArray) {
            return $this->fields;
        }
        $this->tipoDtes($tipoDtesArray);
        $this->camposFactura();
        return $this->fields;
    }

    protected function tipoDtes($tipoDtesArray)
    {
        if (count($tipoDtesArray) == 1) {
            return;
        }
        $this->fields['dte'] = [
            'type' => 'select',
            'label' => __('Documento', 'woocommerce'),
            'options' => $tipoDtesArray,
            'required' => true,
            'class' => ['form-row-wide'],
            'clear' => true,
            'priority' => $this->priority++,
            'default' => get_option('facturapyme_default_dte', 39)
        ];
    }

    protected function camposFactura()
    {
        $conFactura = DataSource::conFactura();
        if (!$conFactura) {
            return;
        }
        $required = false;
        $request = filter_input_array(INPUT_POST);
        if (isset($request['dte']) && ($request['dte'] == 33 || $request['dte'] == 34)) {
            $required = true;
        }
        //if estoy enviando y es factura required = true
        $configuraciones = [
            'facturapyme_rut_dte' => [
                'label' => 'RUT',
                'default' => 'facturapyme_rut_field',
                'class' => ['form-row-wide', 'fp-hidden', 'dte33', 'facturapyme_rut'],
            ],
            'facturapyme_razon_social_dte' => [
                'label' => 'Razón Social',
                'default' => 'billing_company',
                'class' => ['form-row-wide', 'fp-hidden', 'dte33'],
            ],
            'facturapyme_giro_dte' => [
                'label' => 'Giro',
                'default' => 'facturapyme_giro_field',
                'class' => ['form-row-wide', 'fp-hidden', 'dte33'],
            ],
            'facturapyme_comuna_dte' => [
                'label' => 'Comuna',
                'default' => 'facturapyme_comuna_field',
                'class' => ['form-row-wide', 'fp-hidden', 'dte33'],
            ],
        ];
        foreach ($configuraciones as $id => $config) {
            $current = get_option($id, $config['default']);
            $this->fields[$current] = [
                'label' => __($config['label'], 'woocommerce'),
                'required' => $required,
                'class' => $config['class'],
                'clear' => true,
                'priority' => $this->priority++,
            ];
        }
    }
}
